******************************************************************************************************************
* Bootstrapped disability employment results
* Full BOOTSTRAP version - see explanation in master .do file
* Started 13/6/2017, based on earlier 19/8/2015 code
******************************************************************************************************************

*_____________________________________________________________________________________________________________________________________________________
*
* BOOTSTRAP COMMAND
*_____________________________________________________________________________________________________________________________________________________

capture program drop disempBS_trend
program define disempBS_trend, eclass
		syntax [varlist] [if], wavevar(name) distypes(namelist) disvar(name) predictedvar(name) [fixedpredvar(name)] [wgvar(name)] [irtvar(name)] [allirtvar(name)] empvar(name) [controls(varlist fv)] [controls2(varlist fv)] // have removed [subclustervar(name)]  - subclustervar is e.g. country-waves when the cluster var is countries - the varlist in the command is the higher-level grouping
		tokenize 		"`varlist'"
		local clustervar	"`1'"			
		dis _newline(20) "Next iteration - distypes are `distypes', predictedvar is `predictedvar', prediction var wo random element is `fixedpredvar', IRT var is `irtvar', disvar is `disvar', empvar is `empvar', regimevar is removed, clustervar is `clustervar'"
		
		****************************************************************************************************
		* PRELIMINARIES
		****************************************************************************************************
		// Creating the predicted disvar for each iteration - weights are constant, but random element needs to change in each botstrap replication 
		capture drop rand1 
		capture drop `predictedvar'
		gen rand1 = runiform()
		gen 	`predictedvar' = 0 if						 ~missing(p_predicted)
		replace `predictedvar' = 1 if p_predicted  > rand1 & ~missing(p_predicted)
		label var `predictedvar' "Disability IN BOOTSTRAP - regression-based measure using ${disvar}"

		
		****************************************************************************************************
		* ESTIMATION COMMANDS
		****************************************************************************************************
		foreach distype	in `distypes' {
			
			// Command for DIS EMP GAP
			logit `empvar' ib(1).``distype'var'##i.`clustervar'##i.`wavevar' `controls' `controls2' i.`wavevar'#(`controls' `controls2') `if' [pw=${pweight}]	// , vce(cluster mergeid)

			* Samples sizes  in the matrix n_`distype' (e.g. n_predicted), which is outputted from the command below
				matrix n_`distype' =  `e(N)' 												// [1,1] is obs, [1,2] is n(people) = `e(N_clust)'
					levelsof `clustervar' if e(sample), local(wavelist_`distype')			// numbers of clusters (e.g. countries, regimes)
				matrix n_`distype' = n_`distype' , wordcount("`wavelist_`distype''")		// revises the matrix so that there's an extra col with number of country-wave clusters
				* Margins
			margins i.``distype'var' , over(`clustervar' i.`wavevar') 	nose noesample post at(${controlsmeans}) 
				matrix reg_disemp_`distype' = e(b)

			// Command for DIS ITSELF
			logit 				``distype'var'    (i.`clustervar' `controls' `controls2')##i.`wavevar'  `if' [pw=${pweight}] // , vce(cluster mergeid)
				matrix  n_`distype' =  n_`distype', `e(N)'									// Sample size for dis, just as a check
				* Margins
			margins					, over(`clustervar' i.`wavevar') 	nose noesample post at(${controlsmeans}) 
				matrix reg_dis_`distype' = e(b)
			
			// Labelling the matrix of sample sizes
			matrix colnames n_`distype' = "obs_emp_`distype'" "cw_emp_`distype'" "obs_dis_`distype'" // labelling the matrix
		/*end of distypes loop*/ }
		
		****************************************************************************************************
		* OUTPUTTING
		****************************************************************************************************
	
		// GENERATING NEW VECTORS OF RESULTS
		// The alternative of using ERETURN MATRIX would work, except that bootstrap won't allow you to bootstrap the whole vector of results.
		foreach distype	in `distypes' {	
			local i = 0
			foreach cluster in `wavelist_`distype'' 	{
				local i = `i' + 1
				local out_colnames_`distype' = "`out_colnames_`distype''  `cluster'.`clustervar'"
				// Dis prevalence w2
				if `i'==1	matrix disw2_`distype'		= 				 							   reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`cluster'.`clustervar'#2.`wavevar'")]
				else 		matrix disw2_`distype'		= disw2_`distype', 							   reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`cluster'.`clustervar'#2.`wavevar'")]
				// Dis prevalence w3
				if `i'==1	matrix disw3_`distype'		= 				 							   reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`cluster'.`clustervar'#3.`wavevar'")]
				else 		matrix disw3_`distype'		= disw3_`distype', 							   reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`cluster'.`clustervar'#3.`wavevar'")]
				// Dis emp w2
				if `i'==1	matrix disempw2_`distype'	= 					    reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#2.`wavevar'#1.``distype'var'")]    
				else 		matrix disempw2_`distype'	= disempw2_`distype',   reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#2.`wavevar'#1.``distype'var'")]    	
				// Dis emp w3
				if `i'==1	matrix disempw3_`distype'	= 					    reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#3.`wavevar'#1.``distype'var'")]    
				else 		matrix disempw3_`distype'	= disempw3_`distype',   reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#3.`wavevar'#1.``distype'var'")]    		
				// Non-dis emp w2 (WORKING)
				if `i'==1	matrix nodisempw2_`distype' = 					    reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#2.`wavevar'#0.``distype'var'")]    
				else 		matrix nodisempw2_`distype' = nodisempw2_`distype', reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#2.`wavevar'#0.``distype'var'")]    	
				// Non-dis emp w3 (WORKING)
				if `i'==1	matrix nodisempw3_`distype'	= 					    reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#3.`wavevar'#0.``distype'var'")]    
				else 		matrix nodisempw3_`distype'	= nodisempw3_`distype', reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`cluster'.`clustervar'#3.`wavevar'#0.``distype'var'")]    		
				// PPFW (% prevented from working) calculations w2
				if `i'==1	matrix ppfww2_`distype'	= 					disw2_`distype'[1,`i'] * (nodisempw2_`distype'[1,`i'] - disempw2_`distype'[1,`i'])
				else 		matrix ppfww2_`distype'	= ppfww2_`distype', disw2_`distype'[1,`i'] * (nodisempw2_`distype'[1,`i'] - disempw2_`distype'[1,`i'])
				// PPFW (% prevented from working) calculations w3
				if `i'==1	matrix ppfww3_`distype'	= 					disw3_`distype'[1,`i'] * (nodisempw3_`distype'[1,`i'] - disempw3_`distype'[1,`i'])
				else 		matrix ppfww3_`distype'	= ppfww3_`distype', disw3_`distype'[1,`i'] * (nodisempw3_`distype'[1,`i'] - disempw3_`distype'[1,`i'])
				// Dis emp gap is done just below for all clusters together		
			/*end country-wave loop*/ 		}
		// Emp gap + trends for all measures
		matrix disgapw2_`distype'	= nodisempw2_`distype' 	- disempw2_`distype'
		matrix disgapw3_`distype'	= nodisempw3_`distype' 	- disempw3_`distype'
		matrix disgaptr_`distype' 	= disgapw3_`distype' 	- disgapw2_`distype'
		matrix distr_`distype' 		= disw3_`distype' 		- disw2_`distype'
		matrix disemptr_`distype' 	= disempw3_`distype' 	- disempw2_`distype'
		matrix ppfwtr_`distype' 	= ppfww3_`distype' 		- ppfww2_`distype'
		/*end distype loop*/ }

		
		// Labelling and output
		* Labelling the columns
		local matlist "disgapw2 disgapw3 disgaptr disw2 disw3 distr disempw2 disempw3 disemptr ppfww2 ppfww3 ppfwtr"	
		foreach distype	in `distypes' {			
			* The sample sizes are done first, as slightly different to dis disemp disgap ppfw
			matrix coleq	n_`distype' = n_`distype'
			* `fullmatlist' is a complete list of matrices to be posted just below
			if "`fullmatlist'"~=""	local fullmatlist "`fullmatlist', n_`distype'"		// This needs to be first - otherwise first results are duplicated!
			if "`fullmatlist'"==""	local fullmatlist "n_`distype'"
			* Now adding dis disemp disgap ppfw to this
				foreach output in `matlist' {
					matrix colnames `output'_`distype' = `out_colnames_`distype''
					matrix coleq	`output'_`distype' = `output'_`distype'
					local fullmatlist "`fullmatlist', `output'_`distype'" 	// A complete list of matrices to be posted just below
			/*end loop over outputs */ }
		/*end loop over distypes*/ }
		
		// COMBINING VECTORS OF REGRESSION RESULTS INTO e(b)
		tempname bb
		matrix `bb' = `fullmatlist'
		matrix list `bb'
		ereturn post `bb' 
		ereturn local cmd="bootstrap"
end

